const express = require('express');
const router = express.Router();
const jwt = require('jsonwebtoken');
const bcrypt = require('bcrypt');

router.post('/login', async (req, res) => {
    const { email, password } = req.body;

    try {
        if (email !== process.env.ADMIN_EMAIL) {
            return res.status(401).json({ message: "Invalid Credentials" });
        }

        

        const isMatch =  bcrypt.compare(password, process.env.ADMIN_PASSWORD_HASH);
        
        if (!isMatch) {
            return res.status(401).json({ message: "Invalid Credentials" });
        }

        const token = jwt.sign(
            { role: 'admin' }, 
            process.env.JWT_SECRET, 
            { expiresIn: '12h' }
        );

        res.json({
            success: true,
            token: token,
            message: "Authentication successful"
        });

    } catch (error) {
        res.status(500).json({ message: "Server error during login" });
    }
});

module.exports = router;